/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import morph.avaritia.api.CompressorRecipe;
import morph.avaritia.api.ExtremeCraftingRecipe;
import morph.avaritia.client.gui.ExtremeCraftingTableScreen;
import morph.avaritia.client.gui.NeutroniumCompressorScreen;
import morph.avaritia.compat.jei.CompressorRecipeCategory;
import morph.avaritia.compat.jei.ExtremeBasicRecipeTransferInfo;
import morph.avaritia.compat.jei.ExtremeRecipeCategory;
import morph.avaritia.container.ExtremeCraftingMenu;
import morph.avaritia.init.AvaritiaModContent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class AvaritiaJEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = new ResourceLocation("avaritia", "plugin");
    public static final RecipeType<ExtremeCraftingRecipe> EXTREME_CRAFTING_TYPE = RecipeType.create((String)"avaritia", (String)"extreme_crafting", ExtremeCraftingRecipe.class);
    public static final RecipeType<CompressorRecipe> COMPRESSOR_TYPE = RecipeType.create((String)"avaritia", (String)"compressor", CompressorRecipe.class);

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CompressorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ExtremeRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        RecipeManager recipeManager = level.m_7465_();
        registration.addRecipes(COMPRESSOR_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)AvaritiaModContent.COMPRESSOR_RECIPE_TYPE.get()));
        registration.addRecipes(EXTREME_CRAFTING_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)AvaritiaModContent.EXTREME_CRAFTING_RECIPE_TYPE.get()));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ExtremeCraftingMenu.class, EXTREME_CRAFTING_TYPE, 1, 81, 82, 36);
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new ExtremeBasicRecipeTransferInfo());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)AvaritiaModContent.COMPRESSOR_BLOCK.get()), new RecipeType[]{COMPRESSOR_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_ITEM.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)AvaritiaModContent.DOUBLE_COMPRESSED_CRAFTING_TABLE_ITEM.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)AvaritiaModContent.EXTREME_CRAFTING_TABLE_BLOCK.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)AvaritiaModContent.EXTREME_CRAFTING_TABLE_BLOCK.get()), new RecipeType[]{EXTREME_CRAFTING_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(NeutroniumCompressorScreen.class, 62, 35, 22, 15, new RecipeType[]{COMPRESSOR_TYPE});
        registration.addRecipeClickArea(ExtremeCraftingTableScreen.class, 175, 79, 28, 26, new RecipeType[]{EXTREME_CRAFTING_TYPE});
    }
}

